<title>Job Details -Best Leearning</title>
@extends('user.layouts.master')
@section('css')
    <link href="{{ asset('frontend/user/assets/css/nucleo.css') }}" id="app-style" rel="stylesheet" type="text/css">
    <link href="{{ asset('frontend/user/assets/css/fontawesome-all.css') }}" id="app-style" rel="stylesheet" type="text/css">
    <link href="{{ asset('frontend/user/assets/css/argon.css') }}" id="app-style" rel="stylesheet" type="text/css">
    <link href="{{ asset('frontend/user/assets/css/myapp.css') }}" id="app-style" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/bttn.css" type="text/css">
    
    <style>
        .gallery-img {
            display: flex;
            align-items: center;
            justify-content: center;
            height: calc(100% - 64px);
            padding-top: 0;
            width: 100%;
            padding: 0 50px;
        }
        .gallery-img img {
            width: 100%;
            height: auto;
            max-height: 250px;
        }
        .progress {
            height: 3px !important;
        }
        .bg-csgreen {
            background:#22ab59;
                }
                ::selection {
            color: #fff;
            background: #ffad29;
        }

        .post_thumb_class {
            width: 90%;
            margin-bottom: 12px;
            border-radius: 4px;
            max-height: 400px;
        }
        .bg-csyellow {
            background:#17a2b8;
        }
    </style>
@endsection
@section('user-content')
    @if(session('paused_success'))
        <div class="alert alert-danger" style="font-weight:bold;">
            <i class="far fa-frown"></i>
            <span id="pausedSuccessMessage" class="ms-2">Pause Success</span>
            <button type="button" class="close" onclick="closePausedMessage()">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if(session('resume_success'))
        <div class="alert alert-success" style="font-weight:bold;">
            <i class="fas fa-check"></i>
            <span id="resumeSuccessMessage" class="ms-3">Resume Success</span>
            <button type="button" class="close" onclick="closeResumeMessage()">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    <div class="row card-wrapper">
        <div class="col-lg-8">
            <div class="row card-wrapper">
                <div class="col">
                    <!-- Earning $$ -->
                    <div class="card card-pricing border-0 text-center mb-4">
                        <div class="card-body">
                            @if ($job->status == 1)
                               <div class="bold-text"><span style="color: green">ID:</span> {{ $job->code }}</div>
                            @else
                               <div class="bold-text"><span style="background-color: red; color: white; padding: 2px;">ID: {{ $job->code }}</span></div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-sm-6">
                    <!-- Job Done Stats -->
                    <div class="card card-stats">
                        <div class="card-body" >
                            <div class="row">
                                <div class="col">
                                    <h5 class="card-title text-uppercase text-muted mb-0">DONE</h5>
                                    <span class="h2 font-weight-bold mb-0">{{ complete_work_this_job($job->id) }} of {{ $job->worker_need }}</span>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape text-white rounded-circle shadow" style="background: #fec30f;">
                                        <i class="fas fa-check"></i>
                                    </div>
                                </div>
                            </div>
                            <p class="mt-3 mb-0 text-sm"></p>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <!-- Earning $$ -->
                    <div class="card card-pricing border-0 text-center mb-4">
                        <div class="card-body">
                            <div class="display-4">${{ number_format($job->each_worker_earn, 4) }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Job Details -->
            <div class="card">
                <div class="card-header">
                    <h5 class="h3 mb-0">{{ $job->title }}</h5>
                    <hr>
                    @if(!empty($job->thumbnail_image))     
                        <div style="text-align:center">
                            <img class="post_thumb_class" src="{{ URL::to($job->thumbnail_image) }}" width="100%" height="350px"/>
                        </div>
                    @endif
                </div>
            
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-6">
                            <span style="padding: 5px" class="card-text text-muted">
                                <i class="fas fa-globe"></i> {{ continent($job->continent_id) }}
                            </span>
                        </div>
                        <div class="col-sm-6">
                            <span style="padding: 5px" class="card-text text-muted"><i class="fas fa-cogs"></i>
                                {{ category($job->category_id) }} - {{ sub_category($job->sub_category) }}
                            </span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-6">
                                <span style="padding: 5px" class="card-text text-muted">
                                    <i class="fas fa-globe"></i> Exclude Country -
                                </span>
                            </div>
    
                            <div class="col-sm-6">
                                <span style="padding: 5px" class="card-text text-muted"> <i class="fas fa-clock"></i> Time: {{ $job->estimited_day }} Days</span>
                            </div>
                            
                            <div class="col-sm-6">
                                <span style="padding: 5px" class="card-text text-muted">Last Updated- {{ \Carbon\Carbon::parse($job->created_at)->format('d/m/Y g:i A')}} </span>
                            </div>
                        </div>

                        <br>
                        <br>
                        <p class="card-text text-uppercase text-muted font-weight-600"><i class="fas fa-tasks"></i> Task Steps</p>
                                            <p class="card-text font-weight-500">{{ specific_task($job->id) }}</p>
                </div>
            </div>

            <!-- Prove Need -->
            <div class="card">
                <div class="card-header">
                    <h5 class="h3 mb-0 text-uppercase text-muted font-weight-600"> Required Proof</h5>
                </div>
                <div class="card-body">
                    <p>
                        <pre class="card-text font-weight-500">{{ $job->required_proof }}</pre>
                    </p>
                </div>
            </div>

            <div class="card-body">
                    @if($job->pause == 1)
                        <b><h5><marquee style="color:red ;padding: 5px;border-radius: 5px;border:1px solid white" behavior="scroll" >Hello Sir, This job is now Paused, Please Resume for Workers!</marquee> </b></h5>
                    @endif
            </div>
            <div class="card-body drk-bg-second">
                <div class="d-flex gap-2  mb-4">
                    <@if ($job->status == 1)
                        @if ($job->worker_need != $job->worker_confirmed && $job->pause != 1)
                            @if(job_ready_for_boost($job->id) == 1)
                                <a href="javascript:;" class="btn btn-lg btn-primary" onclick="boostJob({{ $job->id }})">Boost</a>
                            @else
                                <a href="javascript:;" class="btn btn-lg btn-primary" onclick="boostJob({{ $job->id }})">{{remain_interval_for_boost($data->id)}}m</a>
                            @endif
                        @endif
                    @endif
                    
                    <a href="{{route('user.job-delete',$job->id)}}" class="btn btn-lg btn-danger">Delete</a>
                   
                    @if ($job->status != 2)
                        <a href="javascript:;" class="btn btn-lg btn-info bttn" onclick="updateJobWorker({{ $job->id }})">Update</a>
                    @endif
                   
                        <a href="{{ route('user.job-edit', $job->id) }}" class="btn btn-lg btn-success">Edit</a>
                    
                    @if($job->status != 2)
                        @if($job->pause == 0)
                            <a href="{{route('user.pause-job',$job->id)}}" class="btn btn-lg btn-danger bttn">Pause</a>
                        @else
                            <a href="{{route('user.start-job',$job->id)}}" class="btn btn-lg btn-success bttn">Resume</a>
                        @endif
                    @endif
                </div>
                
                @if(job_ready_for_boost($job->id) == 1)
                    <div class="modal fade" id="boost_job_{{ $job->id }}" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <form action="{{ route('user.job-boosting-update', $job->id) }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">Boost For "{{ $job->title }}"</h5>
                                    </div>
                                    <div class="modal-body">
                                        <div class="form-group">
                                            <select class="form-control" name="boost_charge" required>
                                                <option value="">Select One</option>
                                                @foreach(boost_charges() as $boost_charge)
                                                    <option value="{{$boost_charge->id}}">{{$boost_charge->duration}} Minutes - ${{$boost_charge->charge}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="boostJobModalClose({{ $job->id }})">Close</button>
                                        <button type="submit" class="btn btn-primary bttn">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                @endif

                @if ($job->worker_need >= $job->worker_confirmed)
                    <div class="modal fade" id="worker_need_{{ $job->id }}" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <form action="{{ route('user.job-work-need-update', $job->id) }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">Edit Job</h5>
                                    </div>
                                    <div class="ms-4">
                                        <p class="text-green"><h5 style="color:blue;">Worker Earn=$ {{ number_format($job->each_worker_earn, 4) }}</p>
                                    </div>
                                    <div class="modal-body">
                                        <label class="form-control-label" for="exampleDatepicker">Worker Need</label>
                                        <div class="form-group col-lg-12 col-md-12 col-12">
                                            <input type="number" class="form-control" id="worker_input_{{ $job->id }}" name="worker" value="0" min="0" required>
                                            <input type="hidden" id="job_fee" value="{{ $job->fee }}">
                                            <br>
                                            <p id="cost_display_{{ $job->id }}" class="" style="padding: 5px;font-weight:bold"></p> 
                                        </div>
                                    </div>
                    
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="updateJobWorkerMosdalClose({{ $job->id }})">Close</button>
                                        <button type="submit" class="btn btn-success bttn">Confirm</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                @endif
            </div>            
            
            <br>
            <br>
        </div>
    </div>
@endsection
@section('js')
    <script>
        function setAccount(account_id) {
            $('#deposit_account').val(account_id);

            $.ajax({
                url: "{{ route('user.deposit-account-info') }}",
                type: "POST",
                data: {
                    _token: '{{ csrf_token() }}',
                    account_id: account_id,
                },
                success: function(data) {
                    $('#deposit_area').show();
                    $('#deposit_account_text').html('Account No: ' + data['account_no']);
                    $('#deposit_account_guideline').html(data['guideline']);
                },
            });
        }
        
        function readURL(id){
            var file = $('#screen_shot_select_image_'+id).get(0).files[0];
            console.log(file);
            if(file){
                $('#screen_shot_show_image_'+id).show();
                var reader = new FileReader();
     
                reader.onload = function(){
                    $('#screen_shot_show_image_'+id).attr("src", reader.result);
                }
     
                reader.readAsDataURL(file);
            }
        }
        
        function updateJobWorker(id){
            $('#worker_need_'+id).modal('show');
        }

        function updateJobWorkerMosdalClose(id){
            $('#worker_need_'+id).modal('hide');
        }
        
        function boostJob(id){
            $('#boost_job_'+id).modal('show');
        }

        function boostJobModalClose(id){
            $('#boost_job_'+id).modal('hide');
        }
        
        function closePausedMessage() {
            var pausedMessage = document.querySelector('.alert-danger');
            pausedMessage.style.display = 'none';
        }
        
        function closeResumeMessage() {
            var resumeMessage = document.querySelector('.alert-success');
            resumeMessage.style.display = 'none';
        }
        
        function calculateCost(jobId) {
        const workerInput = document.getElementById('worker_input_' + jobId);
        const costDisplay = document.getElementById('cost_display_' + jobId);
        const jobFee = parseFloat('7%');
        //const jobFee = parseFloat($('#job_fee').val());
        const eachWorkerEarn = parseFloat('{{ $job->each_worker_earn }}');
        const userDepositBalance = parseFloat('{{ Auth::user()->deposit_balance }}');

        let workers = parseInt(workerInput.value);
        if (isNaN(workers) || workers < 0) {
            workers = 0;
        }

        const totalCost = eachWorkerEarn * workers;
        const fee = (totalCost * jobFee) / 100;
        const budget = totalCost + fee;

        costDisplay.textContent = 'Cost = $' + budget.toFixed(4);

        if (userDepositBalance < budget) {
            costDisplay.style.color = 'red';
        } else {
            costDisplay.style.color = '#2ECC71';
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
        const jobId = '{{ $job->id }}';
        const workerInput = document.getElementById('worker_input_' + jobId);

        workerInput.addEventListener('input', function () {
            calculateCost(jobId);
        });

        calculateCost(jobId);
    });
    </script>
@endsection
